import React from 'react';
import { CircularProgressbarWithChildren } from 'react-circular-progressbar';
import useStyles from './styles';

type Props = {
    strings: object,
    progress: number
};

function DeviceConnecting({ strings, progress }: Props) {
    const classes = useStyles();
    return (
        <div className={classes.downloadingUpdateContainer}>
            <CircularProgressbarWithChildren
                classes={{
                    path: classes.updatingFirmwareProgressBar,
                    trail: classes.updatingFirmwareProgressBarTrail
                }}
                className={classes.updatingFirmwareProgress}
                value={progress}
            />
            <div className={classes.downloadingUpdateTitle}>
                {strings.welcome_device_connecting}
            </div>
        </div>
    );
}

export default DeviceConnecting;
